//  
//  wr.cs
//  
//  Author:
//       Robert BRACCAGNI alias Gai-Luron <lfsgailuron@free.fr>
// 
//  Copyright (c) 2010 Gai-Luron
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.


using System;
using System.Collections;
using System.Text;
using System.Net;
using System.IO;


namespace LFSLapper
{
    public class wr
    {
        System.Collections.Hashtable trackTable = new System.Collections.Hashtable();
        Hashtable wrTracks = new Hashtable();

        public class WrEntry
        {
            public string track;
            public string car;
            public string racername;
            public long laptime;
            public long[] split = new long[3];
            public long[] sector = new long[3];
            public long split1;
            public long split2;
            public long split3;
            public long numsplits;
            public long flags;
            public long timestamp;

            public WrEntry(string track, string car, string racername, long laptime, long split1, long split2, long split3, long flags, long timestamp)
            {
                this.track = track;
                this.car = car;
                this.racername = racername;
                this.laptime = laptime;
                this.flags = flags;
                this.timestamp = timestamp;
                this.split[0] = split1;
                this.split[1] = split2;
                this.split[2] = split3;
                this.sector[0] = this.sector[1] = this.sector[2] = 0;   //Zero out the sector times
                if (split3 != 0)
                {
                    this.numsplits = 3;
                }
                else if (split2 != 0)
                {
                    this.numsplits = 2;
                }
                else
                {
                    this.numsplits = 1;
                }
            }
        }
        public class WrTrackData
        {
            public string track;
            public Hashtable wrEntries = new Hashtable();
            public WrTrackData(string track)
            {
                this.track = track;
            }
        }
        public class wrInfo
        {
            public string track;
            public string CName;
            public string racerName;
            public long WRTime;
            public long[] split = new long[3];
            public long[] sectorSplit = new long[3];
            public long sectorSplitLast;
            public long flags;

        
            public wrInfo(string track, string CName, long WRTime, long split1, long split2, long split3, long sectorSplit1, long sectorSplit2, long sectorSplit3, long sectorSplitLast, long flags, string racerName)
            {
                this.track = track;
                this.CName = CName;
                this.racerName = racerName;
                this.WRTime = WRTime;
                this.split[0] = split1;
                this.split[1] = split2;
                this.split[2] = split3;
                this.sectorSplit[0] = sectorSplit1;
                this.sectorSplit[1] = sectorSplit2;
                this.sectorSplit[2] = sectorSplit3;
                this.sectorSplitLast = sectorSplitLast;
                this.flags = flags;
            }
        }
        public class trackInfo : System.IComparable
        {
            public string track;
            public System.Collections.Hashtable carTable = new System.Collections.Hashtable();
            public trackInfo(string track)
            {
                this.track = track;
            }
            public int CompareTo(object x)
            {
                if (string.Compare((x as trackInfo).track, this.track) < 0)
                    return 1;
                else if (string.Compare((x as trackInfo).track, this.track) > 0)
                    return -1;
                else
                    return 0;
            }
        }
        public wrInfo getWR(string track, string CName )
        {
            wrInfo wi;
            try
            {
                trackInfo tt = (trackTable[track] as trackInfo);
                wi = (wrInfo)tt.carTable[CName];
                return wi;
            }
            catch { return null; }

        }
        public bool load(string user, string pass, string idk)
        {
            string readLine;

            long split1 = 0;
            long split2 = 0;
            long split3 = 0;
            long lastSplit = 0;
            long sectorSplit1 = 0;
            long sectorSplit2 = 0;
            long sectorSplit3 = 0;
            long sectorSplitLast = 0;
            long WRTime = 0;
            long flags = 0;
            long timeStamp;

            string url;
            if (idk == "")
            {
                return false;
            }
            try
            {
                url = "http://www.lfsworld.net/pubstat/get_stat2.php?version=1.5&idk=" + idk + "&action=wr";
                WebRequest req = WebRequest.Create(url);
                req.Timeout = (int)paramLapper.webTimeOut;
                WebResponse result = req.GetResponse();
                Stream receiveStream = result.GetResponseStream();
                using (StreamReader sr = new StreamReader(receiveStream))
                {
                    while (true)
                    {
                        readLine = sr.ReadLine();
                        if (readLine == null)
                            break;
                        if (readLine.IndexOf("Identification") != -1)
                            return false;
                        if (readLine.IndexOf("can't") != -1)
                            return false;
                        string[] mline = readLine.Split(' ');

                        string track = UTILS.utils.convTrack(mline[1]);
                        string car = mline[2];
                        lastSplit = 0;
                        sectorSplit1 = 0;
                        sectorSplit2 = 0;
                        sectorSplit3 = 0;
                        sectorSplitLast = 0;
                        split1 = long.Parse(mline[3]);
                        sectorSplit1 = split1 - lastSplit;
                        lastSplit = split1;

                        split2 = long.Parse(mline[4]);
                        if (split2 != 0)
                        {
                            sectorSplit2 = split2 - lastSplit;
                            lastSplit = split2;
                        }

                        split3 = long.Parse(mline[5]);
                        if (split3 != 0)
                        {
                            sectorSplit3 = split3 - lastSplit;
                            lastSplit = split3;
                        }
                        WRTime = long.Parse(mline[6]);
                        sectorSplitLast = WRTime - lastSplit;
                        timeStamp = long.Parse(mline[mline.Length - 1]);
                        string racerName = string.Join(" ", mline, 8, mline.Length - 9);

						
                        if (!trackTable.ContainsKey(track))
                        {
                            trackTable[track] = new trackInfo(track);
                        }
                        trackInfo tt = (trackTable[track] as trackInfo);
                        if (!tt.carTable.ContainsKey(car))
                        {
                            tt.carTable[car] = new wrInfo(track, car, WRTime, split1, split2, split3, sectorSplit1, sectorSplit2, sectorSplit3, sectorSplitLast, timeStamp, racerName);
                        }
                        if ( !wrTracks.ContainsKey(track) )
                        {
                            wrTracks[track] = new WrTrackData(track);
                        }
                        WrTrackData wt = (wrTracks[track] as WrTrackData);
                        if ( ! wt.wrEntries.ContainsKey(car) )
                        {
                            wt.wrEntries[car] = new WrEntry(track, car, racerName, WRTime, split1, split2, split3, flags, timeStamp);
                        }
                    }
                }
                return true;
            }
            catch
            {
                return false;
            }
        }
    }
}
